% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_numeric_viz.R
\name{ExpNumViz}
\alias{ExpNumViz}
\title{Distributions of numeric variables}
\usage{
ExpNumViz(
  data,
  target = NULL,
  type = 1,
  nlim = 3,
  fname = NULL,
  col = NULL,
  Page = NULL,
  sample = NULL,
  scatter = FALSE,
  gtitle = NULL,
  theme = "Default"
)
}
\arguments{
\item{data}{dataframe or matrix}

\item{target}{target variable}

\item{type}{1 (boxplot by category and overall), 2 (boxplot by category only), 3 (boxplot for overall)}

\item{nlim}{numeric variable unique limit. Default nlim is 3, graph will exclude the numeric variable which is having less than 'nlim' unique value}

\item{fname}{output file name}

\item{col}{define the fill color for box plot. Number of color should be equal to number of categories in target variable}

\item{Page}{output pattern. if Page=c(3,2), It will generate 6 plots with 3 rows and 2 columns}

\item{sample}{random selection of plots}

\item{scatter}{option to run scatter plot between all the numerical variables (default scatter=FALSE)}

\item{gtitle}{chart title}

\item{theme}{adding extra themes, geoms, and scales for 'ggplot2' (eg: themes options from ggthemes package)}
}
\value{
returns collated graphs in PDF or JPEG format

\itemize{
  \item \code{Univariate plot} density plot for all the numeric data with the value of shape of the distribution (Skewness & Kurtosis)
  \item \code{Bivariate plot} correlatin plot for all the numeric data
  \item \code{Bivariate plot} scatter plot between continuous dependent variable and Independent variables
  \item \code{Box plot} by overall sample
  \item \code{Box plot} by stratified sample
}
}
\description{
This function automatically scans through each variable and creates density plot, scatter plot and box plot for continuous variable using ggplot2 functions.
}
\details{
This function automatically scan each variables and generate a graph based on the user inputs. Graphical representation includes scatter plot, box plot and density plots.

All the plots are generated using ggplot2 pacakge function (geom_boxplot, geom_density, geom_point)

The plots are combined using gridExtra pacakge functions

\itemize{
  \item \code{target} is continuous then output is scatter plots
  \item \code{target} is categorical then output is box plot
  \item \code{target} is NULL then density plot for all numeric features
  \item \code{scatter = TRUE} generate multiple scatter plot between all the independent contionuos variables with or without group argument
}
}
\examples{
## Generate Boxplot by category
ExpNumViz(iris,target = "Species", type = 2, nlim = 2,
           col = c("red", "green", "blue", "pink"), Page = NULL, sample = 2, scatter = FALSE,
           gtitle = "Box plot: ")
## Generate Density plot
ExpNumViz(iris, nlim = 2,
           col = NULL,Page = NULL, sample = 2, scatter = FALSE,
           gtitle = "Density plot: ")
## Generate Scatter plot by Dependent variable
ExpNumViz(iris,target = "Sepal.Length", type = 1, nlim = 2,
           col = "red", Page = NULL, sample = NULL, scatter = FALSE,
           gtitle = "Scatter plot: ", theme = "Default")
## Generate Scatter plot for all the numerical variables
ExpNumViz(iris,target = "Species", type = 1, nlim = 2,
           col = c("red", "green", "blue"), Page = NULL, sample = NULL, scatter = TRUE,
           gtitle = "Scatter plot: ", theme = "Default")
}
\seealso{
\code{\link[ggplot2:geom_boxplot]{geom_boxplot}}
\code{\link[ggthemes:ggthemes]{ggthemes}}
\code{\link[ggplot2:geom_density]{geom_density}}
\code{\link[ggplot2:geom_point]{geom_point}}
}
