% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothT.R
\name{Spectral}
\alias{Spectral}
\title{Spectral method for nonparametric tensor estimation with unknown permutation.}
\usage{
Spectral(A, row_idx, col_idx, threshold = NULL)
}
\arguments{
\item{A}{A given noisy data tensor.}

\item{row_idx}{The indices of the modes that map onto the row space}

\item{col_idx}{The indices of the modes that map onto the column space}

\item{threshold}{A threshold to disregard singular values. Default value is the square root of unfolded matrix dimension.}
}
\value{
An estimated permuted signal tensor based on Spectral method.
}
\description{
Estimate a permuted signal tensor from a noisy data tensor using spectral method, which performs universal singualr value thresholding on the unfolded tensor.
}
\examples{

# Generate the noisy observation from smooth tensor and permutation
d = 20
sim1 = simulation(d,mode = 1)
signal_T = sim1$signal
observe_T = sim1$observe
permutation = sim1$permutation
psignal_T = signal_T[permutation,permutation,permutation]

# Estimate permuted signal tensor
hatpTheta = Spectral(observe_T,1,c(2,3))

# Calculate MSE
mean((hatpTheta-psignal_T)^2)

}
\references{
J. Xu. Rates of convergence of spectral methods for graphon estimation. International Conference on Machine Learning, 2018. \cr C. Lee and M. Wang. Smooth tensor estimation with unknown permutations. arXiv:2111.04681, 2021.
}
