% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FractalDimension.R
\name{fractdim}
\alias{fractdim}
\title{Computation of Fractal Dimension}
\usage{
fractdim(Mass, Size, TM, dmax)
}
\arguments{
\item{Mass}{Numerical vector containing the mass of each particle size class}

\item{Size}{Numerical vector containing the average of each particle size class}

\item{TM}{Numerical value containing the total mass of soil}

\item{dmax}{Numerical value containing the average of maximum particle size class}
}
\value{
Fractal Dimension
}
\description{
The function computes the fractal dimension of particle size distribution based on soil mass
}
\examples{
data <- data.frame(Mass = c(15.1,28.9,11.3,14.6,7.9,22.2),
                   Size = c(0.053,0.1765,0.4,1.25,3.375,4.75))
TM <- 100
dmax <- 4.75
attach(data)
fractdim(Mass = Mass, Size = Size, TM = TM, dmax = dmax)
}
\references{
Tyler S. W., Wheatcraft S. W. (1992). Fractal scaling of soil particle size distribution: Analysis and limitations. Soil Sci. Soc. Am. J., 56: 362.
}
