% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fT.Arrhenius.R
\name{fT.Arrhenius}
\alias{fT.Arrhenius}
\title{Effects of temperature on decomposition rates according the Arrhenius
equation}
\usage{
fT.Arrhenius(Temp, A = 1000, Ea = 75000, Re = 8.3144621)
}
\arguments{
\item{Temp}{A scalar or vector containing values of temperature (in degrees
Kelvin) for which the effects on decomposition rates are calculated.}

\item{A}{A scalar defining the pre-exponential factor.}

\item{Ea}{A scalar defining the activation energy in units of J mol^-1.}

\item{Re}{A scalar defining the universal gas contents in units of J K^-1
mol^-1.}
}
\value{
A scalar or a vector containing the effects of temperature on
decomposition rates (unitless).
}
\description{
Calculates the effects of temperature on decomposition rates according to
the Arrhenius equation.
}
