% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnalyteInfo.R, R/getTargetNames.R,
%   R/z-deprecated.R
\name{getAnalyteInfo}
\alias{getAnalyteInfo}
\alias{getTargetNames}
\alias{getFeatureData}
\title{Get Analyte Annotation Information}
\usage{
getAnalyteInfo(adat)

getTargetNames(tbl)

getFeatureData(adat)
}
\arguments{
\item{adat}{A \code{soma_adat} object (with intact attributes),
typically created using \code{\link[=read_adat]{read_adat()}}.}

\item{tbl}{A \code{tibble} object containing analyte target annotation
information. This is usually the result of a call to \code{\link[=getAnalyteInfo]{getAnalyteInfo()}}.}
}
\value{
A \code{tibble} object with columns corresponding
to the column meta data entries in the \code{soma_adat}. One row per analyte.
}
\description{
Uses the \code{Col.Meta} attribute (analyte annotation data that appears above
the protein measurements in the \verb{*.adat} text file) of a \code{soma_adat} object,
adds the \code{AptName} column key, conducts a few sanity checks, and
generates a "lookup table" of analyte data that can be used for simple
manipulation and indexing of analyte annotation information.
Most importantly, the analyte column names of the \code{soma_adat}
(e.g. \code{seq.XXXX.XX}) become the \code{AptName} column of the lookup table and
represents the key index between the table and \code{soma_adat} from which it comes.
}
\section{Functions}{
\itemize{
\item \code{getTargetNames()}: creates a lookup table (or dictionary) as a named list object of \code{AptNames}
and Target names in key-value pairs.
This is a convenient tool to quickly access a \code{TargetName} given
the \code{AptName} in which the key-value pairs map the \code{seq.XXXX.XX}
to its corresponding \code{TargetName} in \code{tbl}.
This structure which provides a convenient auto-completion mechanism at
the command line or for generating plot titles.

\item \code{getFeatureData()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}. Please now use \code{\link[=getAnalyteInfo]{getAnalyteInfo()}}.

}}
\examples{
# Get Aptamer table
anno_tbl <- getAnalyteInfo(example_data)
anno_tbl

# Use `dplyr::group_by()`
dplyr::tally(dplyr::group_by(anno_tbl, Dilution))  # print summary by dilution

# Columns containing "Target"
anno_tbl |>
  dplyr::select(dplyr::contains("Target"))

# Rows of "Target" starting with MMP
anno_tbl |>
  dplyr::filter(grepl("^MMP", Target))

# Target names
tg <- getTargetNames(anno_tbl)

# how to use for plotting
feats <- sample(anno_tbl$AptName, 6)
op <- par(mfrow = c(2, 3))
sapply(feats, function(.x) plot(1:10, main = tg[[.x]]))
par(op)
}
\seealso{
\code{\link[=getAnalytes]{getAnalytes()}}, \code{\link[=is_intact_attr]{is_intact_attr()}}, \code{\link[=read_adat]{read_adat()}}
}
\author{
Stu Field
}
