% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spader.R
\name{Genetics}
\alias{Genetics}
\title{Estimation of genetic differentiation measures}
\usage{
Genetics(X, q = 2, nboot = 200)
}
\arguments{
\item{X}{a matrix, or a data.frame of allele frequencies.}

\item{q}{a specified order to use to compute pairwise dissimilarity measures. If \code{q = 0}, this function computes the estimated pairwise Jaccard and Sorensen dissimilarity indices.
If \code{q = 1}, this function computes the estimated pairwise equal-weighted and size-weighted Horn indices;
If \code{q = 2}, this function computes the estimated pairwise Morisita-Horn and regional species-diffrentiation indices.}

\item{nboot}{an integer specifying the number of bootstrap replications.}
}
\value{
a list of ten objects: \cr\cr
\code{$info} for summarizing data information.\cr\cr 
\code{$Empirical_richness} for showing the observed values of the richness-based dis-similarity indices
including the classic Jaccard and Sorensen indices. \cr\cr
\code{$Empirical_relative} for showing the observed values of the equal-weighted dis-similarity
indices for comparing allele relative abundances including Gst, Horn, Morisita-Horn and regional differentiation measures. \cr \cr
\code{$Empirical_WtRelative} for showing the observed value of the dis-similarity index for
comparing size-weighted allele relative abundances, i.e., Horn size-weighted measure based on Shannon-entropy under equal-effort sampling. \cr\cr
The corresponding three objects for showing the estimated dis-similarity indies are: \cr
\code{$estimated_richness},  \code{$estimated_relative} and \code{$estimated_WtRelative}. \cr\cr
\code{$pairwise} and \code{$dissimilarity.matrix} for showing respectively the pairwise dis-similarity
estimates (with related statistics) and the dissimilarity matrix for various measures depending on
the diversity order \code{q} specified in the function argument. \cr\cr
\code{$q} for showing which diversity order \code{q} to compute pairwise dissimilarity.
}
\description{
\code{Genetics}: Estimation allelic differentiation among subpopulations based on multiple-subpopulation
genetics data. The richness-based indices include the classic Jaccard and Sorensen dissimilarity
indices; the abundance-based indices include the conventional Gst measure, Horn, Morisita-Horn
and regional species-differentiation indices. \cr\cr
Only Type (1) abundance data (datatype="abundance") is supported; input data for each sub-population 
include sample frequencies in an empirical sample of individuals. When there are multiple subpopulations, input data consist of an allele-by-subpopulation frequency matrix.
}
\examples{
\dontrun{
# Type (1) abundance data 
data(GeneticsDataAbu)
Genetics(GeneticsDataAbu,q=2,nboot=200)
}
}
\references{
Chao, A., and Chiu, C. H. (2016). Bridging the variance and diversity decomposition approaches to beta diversity via similarity and differentiation measures. Methods in Ecology and Evolution, 7, 919-928. \cr\cr
Chao, A., Jost, L., Hsieh, T. C., Ma, K. H., Sherwin, W. B. and Rollins, L. A. (2015). Expected Shannon entropy and Shannon differentiation between subpopulations for neutral genes under the finite island model. Plos One, 10:e0125471.\cr\cr
Jost, L. (2008). \eqn{G_{ST}} and its relatives do not measure differentiation. Molecular Ecology, 17, 4015-4026.\cr\cr
}

