% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Specs}
\alias{Specs}
\title{\code{Spec}ifications for visual and nonvisual data wrangling and plotting}
\format{
\code{Specs} A list with 7 elements
\describe{
\item{AS_wide}{A table of action spectra for the 5 human receptor types and V(lambda) from 1924. The table is in the wide format. The unit of the wavelength (Wellenlaenge) is nm, the unit of the action spectrum is 1 (dimensionless).}
\item{AS_long}{A table of action spectra for the 5 human receptor types and V(lambda) from 1924. The table is in the long format. The unit of the wavelength (Wellenlaenge) is nm, the unit of the action spectrum is 1 (dimensionless).}
\item{Efficacy}{A named vector of inverse values of efficacy of luminous radiation for the 5 human receptor types and V(lambda) from 1924. The unit is lm/W.}
\item{Alpha}{A list. \code{names} contains the names of the 5 human receptor types. \code{adjectives} contains these names in their adjective form for every languages included in Spectran. \code{descriptions} contains the descriptions used for tables and plotting. \code{abb} contains the abbreviations (if any) used for the equivalent daylight illuminance for that receptor type.}
\item{Vlambda}{A character scalar containing the properly escaped version of V(lambda), used e.g. in Plots}
\item{Alpha.ico}{A character scalar containing the properly escaped version of the sign \code{alpha}, used e.g. in Plots}
\item{Plot}{A table of Peak Wavelength (nm) values, Names, Abbreviations, and colors for the 5 human receptor types and V(lambda) from 1924. This table is mainly used for plotting.}

}
}
\source{
\href{https://cie.co.at/publications/cie-system-metrology-optical-radiation-iprgc-influenced-responses-light-0}{CIE S026}

\href{https://www.dinmedia.de/de/vornorm/din-ts-5031-100/343737176}{DIN/TS 5031-100}
}
\usage{
Specs
}
\description{
Contains vectors and tables that are the main basis for the calculations
Spectran does and also contain basic naming and coloring conventions.
}
\keyword{datasets}
