% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SphereOptimize.R
\name{SphereOptimize}
\alias{SphereOptimize}
\title{Conducting optimization on a unit sphere}
\usage{
SphereOptimize(par, fn, neighbor = NULL, ...)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over. Must be
in Cartesian coordinates and on a unit sphere.}

\item{fn}{A function to be minimized (or maximized).}

\item{neighbor}{Radius of neighbor to search for the optimal results. If not specified, this
function will search for the whole unit sphere.}

\item{...}{Extra arguments that can be passed to optim().}
}
\value{
A list compose three items.
\itemize{
\item par The optimal restuls found.
\item value The value of fn corresponding to par.
\item method The optimization algorithm used.
}
}
\description{
The function SphereOptimize conducts optimization on a unit sphere.
If the size of neighbor near the initial value is specified, the L-BFGS-B opitmization
algorithm will be called. Otherwise this function searches the whole unit sphere using
Nelder-Mead algorithm by default. Other optimization methods are allowed.
}
\examples{
fn = function(s){
    return(sum(s^3))
}

s = c(sqrt(2)/2,sqrt(2)/2)
k = SphereOptimize(s, fn, control = list(fnscale = -1))
k$value
k$par
}
