% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_wilcox.test.R
\name{p_wilcox.test}
\alias{p_wilcox.test}
\title{p-value from Wilcoxon (signed rank) test simulation}
\usage{
p_wilcox.test(
  n,
  d,
  n2_n1 = 1,
  mu = 0,
  type = c("two.sample", "one.sample", "paired"),
  exact = NULL,
  correct = TRUE,
  two.tailed = TRUE,
  parent1 = function(n, d) rnorm(n, d, 1),
  parent2 = function(n, d) rnorm(n, 0, 1),
  return_analysis = FALSE
)
}
\arguments{
\item{n}{sample size per group. For paired samples this corresponds to the
number of pairings (hence, half of the data points observed)}

\item{d}{effect size passed to \code{parent} functions}

\item{n2_n1}{sample size ratio}

\item{mu}{parameter used to form the null hypothesis}

\item{type}{type of analysis to use (two-sample, one-sample, or paired)}

\item{exact}{a logical indicating whether an exact p-value should be computed}

\item{correct}{a logical indicating whether to apply continuity correction
in the normal approximation for the p-value}

\item{two.tailed}{logical; use two-tailed test?}

\item{parent1}{data generation function for first group. Ideally
should have SDs = 1 so that \code{d} reflects a standardized
difference}

\item{parent2}{same as \code{parent1}, but for the second group}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}
}
\value{
a single p-value
}
\description{
Simulates data given one (Wilcoxon) or two (Mann-Whitney)
parent distributions and returns a p-value. Can also be used for power analyses related
to sign tests.
}
\examples{

# with normal distributions defaults d is standardized
p_wilcox.test(100, .5)
p_wilcox.test(100, .5, type = 'paired')  # n = number of pairs
p_wilcox.test(100, .5, type = 'one.sample')

# return analysis object
p_wilcox.test(100, .5, return_analysis = TRUE)

# using chi-squared distributions (standardizing to 0-1)
p_wilcox.test(100, .5, type = 'one.sample',
   parent1 = function(n, d) rchisq(n, df=10) - 10 + d)
p_wilcox.test(100, .5,
   parent1 = function(n, d) (rchisq(n, df=10) - 10)/sqrt(20) + d,
   parent2 = function(n, d) (rchisq(n, df=10) - 10)/sqrt(20))

}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
