% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSHorizontalStack.R
\name{BSHorizontalStack}
\alias{BSHorizontalStack}
\title{Horizontal stacking Random Forest models.}
\usage{
BSHorizontalStack(T = 100, mtry = NA, nodesize = 5, iter = 100,
  Xn = NULL, ECHO = TRUE, Cf = NULL, Y, X1, X2, ...)
}
\arguments{
\item{T}{Number of trees for the individual RF models. (int)}

\item{mtry}{Number of variables available for splitting at each tree node. If a scalar is given then all models use the given values. If a 1D array is given then each individual model uses the given value.}

\item{nodesize}{Minimum size of terminal nodes. If a scalar is given then all models use the given values. If a 1D array is given then each individual model uses the given value. By default all models use 5.}

\item{iter}{The number of time to bootstrap sample the data. (int)}

\item{Xn}{List containing each dataset to be stacked. If not supplied will be generated from X1, X2, ...}

\item{ECHO}{Bool, enable to provide output to the user in terms of overlapping samples and runtime for CV.}

\item{Cf}{Character vector listing set of samples common among all given datasets. If not found will generate on it's own.}

\item{Y}{Nsample x 1 data table of responses for ALL samples. Must have matching rownames with each individual dataset.}

\item{X1}{Data table of first dataset to be stacked. Rownames should be contained within Y.}

\item{X2}{Data table of second dataset to be stacked. Rownames should be contained within Y.}

\item{...}{Further data tables, X3, X4, ..., Xl.}
}
\value{
Weights and offsets for each individual RF model.
}
\description{
Generate the weights for a horizontally stacked set of Random Forest (RF) models given a set of heterogeneous datasets.
For horizontal stacking some subset of samples must be common among all datasets. Subfunction of BSstack but can be used stand-alone.
}
\details{
Required Packages:
  dplyr, randomForest, foreach
}
