% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RHModel.R
\name{rh}
\alias{rh}
\title{Create a Renshaw and Haberman (Lee-Carter with cohorts) mortality model}
\usage{
rh(link = c("log", "logit"), cohortAgeFun = c("1", "NP"),
  approxConst = FALSE)
}
\arguments{
\item{link}{defines the link function and random component associated with 
the mortality model. \code{"log"} would assume that deaths follow a 
Poisson distribution and use a log link while \code{"logit"} would assume 
that deaths follow a Binomial distribution and a logit link.}

\item{cohortAgeFun}{defines the cohort age modulating parameter 
\eqn{\beta_x^{(0)}}. It can take values: \code{"NP"} for a non-parametric age
term or \code{"1"} for \eqn{\beta_x^{(0)}=1} (the default).}

\item{approxConst}{defines if the approximate identifiability constraint of 
Hunt and Villegas (2015) is applied or not. If \code{TRUE}, the output object 
is of class \code{rh} and subsequent model fitting is performed with 
\code{\link{fit.rh}}. If \code{FALSE}, the output object is of class 
\code{StMoMo} and subsequent model fitting is performed with 
\code{\link{fit.StMoMo}}.}
}
\value{
An object of class \code{"StMoMo"} or \code{"rh"}.
}
\description{
Utility function to initialise a \code{StMoMo} object representing a 
Renshaw and Haberman (Lee-Carter with cohorts) mortality model introduced
in Renshaw and Haberman (2006).
}
\details{
The created model is either a log-Poisson or a  logit-Binomial version 
of the Renshaw and Haberman model which has predictor structure   
\deqn{\eta_{xt} = \alpha_x + \beta^{(1)}_x\kappa_t + \beta^{(0)} \gamma_{t-x}.}
or
\deqn{\eta_{xt} = \alpha_x + \beta^{(1)}_x\kappa_t + \gamma_{t-x}.}
depending on the value of argument \code{cohortAgeFun}.
  
To ensure identifiability the following constraints are imposed
\deqn{\sum_t\kappa_t = 0, \sum_x\beta^{(1)}_x = 1, \sum_c\gamma_c = 0}
plus
\deqn{\sum_x\beta^{(0)}_x = 1}
if \code{cohortAgeFun = "NP"}

In addition, if \code{approxConst=TRUE} then the approximate 
identifiability constraint
\deqn{\sum_c (c-\bar{c})\gamma_c = 0}
is applied to improve the stability and robustness of the model 
(see Hunt and Villegas (2015)).

By default \eqn{\beta^{(0)}_x = 1} as this model has shown to be more
stable (see Haberman and Renshaw (2011) and Hunt and Villegas (2015)).
}
\examples{

LCfit <-  fit(lc(), data = EWMaleData, ages.fit = 55:89)
wxt <- genWeightMat(55:89,  EWMaleData$years, clip = 3)
RHfit <- fit(rh(), data = EWMaleData, ages.fit = 55:89, wxt = wxt, 
             start.ax = LCfit$ax, start.bx = LCfit$bx, start.kt = LCfit$kt)
plot(RHfit)

#Impose approximate constraint as in Hunt and Villegas (2015)    
\dontrun{
RHapprox <- rh(approxConst = TRUE)
RHapproxfit <- fit(RHapprox, data = EWMaleData, ages.fit = 55:89, 
                    wxt = wxt)
plot(RHapproxfit) 
}


}
\references{
Haberman, S., & Renshaw, A. (2011). A comparative study of parametric 
mortality projection models. Insurance: Mathematics and Economics, 
48(1), 35-55. 

Hunt, A., & Villegas, A. M. (2015). Robustness and convergence in the 
Lee-Carter model with cohorts. Insurance: Mathematics and Economics, 
64, 186-202. 

Renshaw, A. E., & Haberman, S. (2006). A cohort-based extension to the 
Lee-Carter model for mortality reduction factors. 
Insurance: Mathematics and Economics, 38(3), 556-570.
}
\seealso{
\code{\link{fit.rh}}, \code{\link{StMoMo}}, \link{lc}, \link{apc}
}
