#include "RcppArmadillo.h"
#include "StatRec_latent_sparse.h"
#include "StatRec_latent.h"
#include "StatRec_sparse.h"
#include "StatRec_base.h"

// [[Rcpp::export]]
Rcpp::List model(arma::mat X, arma::mat Y, arma::mat R, int k, int l, 
                               std::string method, bool sparse, int mcmc_samples, int burnin, 
                               bool verbose)
{
  if(l > 0){
    if(sparse){
      return model_latent_sparse(X, Y, R, k, l, method, mcmc_samples, burnin, 
                                 verbose);
    } else {
      return model_latent(X, Y, R, k, l, method, mcmc_samples, burnin, verbose);
    }
  } else{
    if(sparse){
      return model_sparse(X, Y, R, k, method, mcmc_samples, burnin, verbose);
    } else{
      return model_base(X, Y, R, k, method, mcmc_samples, burnin, verbose);
    }
  }
}
                               
