% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step_AIC_BetaBinomial_regression.R
\name{Step_glimML}
\alias{Step_glimML}
\title{Stepwise model selection for Beta-Binomial and Negative Binomial Regressions from aod package}
\usage{
Step_glimML(object, k = 2, overdispersion = T, correctAIC = T)
}
\arguments{
\item{object}{Object of class "glimML". If the class is different the function apply step function in "stats" package}

\item{k}{The penalty parameter used for the criterion, e.g. default is k = 2 which identify the classical AIC. BIC can be obtained as k = log(n)}

\item{overdispersion}{Provide the stepwise procedure also for the overdispersion component of the model (defined as random) Default is TRUE}

\item{correctAIC}{Use AICc instead of AIC. Default TRUE is for AICc}
}
\value{
The algorithm returns an object of class "glimML"
}
\description{
This function performs a stepwise algorithm to define the best linear predictor according to an user defined criterion (defeault is the Akaike Information Criterion aka AIC, but it is also possible to perform the corrected version AICc).
It works only for object from betabin function (class "glimML" from "aod" package). If the object is different from "glimMl" class, the function performs the classical step function in "stats" package.
}
\details{
Step_glimML is different from step (stats) and stepAIC (MASS) functions; for an object of class betabin is impossible to use an algorithm which uses the function extractAIC.
Starting from a full model it provides a backaward procedure where the scope model is the reduced one.

First, Step_glimML operates with all the principal effects included in the model; starting from the full model, the algorithm computes all the possible models, it calculates the measure (default is AIC) and it defines as a good predictor the model with lower AIC.

Then, based on the previous results, Step_glimML operates adding all the possible interactive effects. As in the first passage, the model choosen by the algorithm is the one whose AIC is the lowest.

During the procedure, Step_glimML considers all the possible models which betabin can fit. There are many cases where betabin function falls into error, in these cases the algorithm does not consider the linear predictor which causes the error and it goes forward.
}
\examples{
## Starting from a "betabinom" model

## Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language.
## Wadsworth & Brooks/Cole. (has iris3 as iris.)

## Prepare the data

library(aod)
data(iris)

############ Beta Binomial model
\dontrun{
n <- round(runif(dim(iris)[1],1,50))
y <- round(runif(length(n), 1,n))
data <- cbind(iris,y,n)
fullModel <- betabin(cbind(y, n - y) ~ Sepal.Width * Petal.Length + Petal.Width, ~ Species,
                     data = data)
reducedModel <- Step_glimML(fullModel)
summary(reducedModel)
}
############ Negative Binomial model
\dontrun{
data <- iris
data$Sepal.Length <- round(Sepal.length + runif(dim(data)[1],0,1) * 100)
fullModel <- negbin(Sepal.Length ~ Sepal.Width * Petal.Length + Petal.Width, ~ Species,
                    data = data)
reducedModel <-Step_glimML(fullModel)
summary(reducedModel)
}

}
\references{
Crowder, M.J., 1978. Beta-binomial anova for proportions. Appl. Statist. 27, 34-37.

Lawless, J.F., 1987. Negative binomial and mixed Poisson regression. The Canadian Journal of Statistics, 15(3): 209-225.

Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.

Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language. Wadsworth & Brooks/Cole. (has iris3 as iris.)
}
\author{
Sergio Garofalo
}
