% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getBufferSize}
\alias{getBufferSize}
\alias{getBufferSize,stormsList-method}
\title{Getting the buffer size}
\usage{
getBufferSize(sts)

\S4method{getBufferSize}{stormsList}(sts)
}
\arguments{
\item{sts}{\code{stormsList}}
}
\value{
numeric.
}
\description{
The \code{getBufferSize()} returns the buffer size used to generate
the buffered location of interest for a \code{stormsList} object.
}
\examples{
#Creating a stormsDataset
\donttest{
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the buffer size from the sts object
buffsize <- getBufferSize(sts)
}
}
