% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getNames}
\alias{getNames}
\alias{getNames,storm-method}
\alias{getNames,stormsList-method}
\title{Getting the names of the storms}
\usage{
getNames(s)

\S4method{getNames}{storm}(s)

\S4method{getNames}{stormsList}(s)
}
\arguments{
\item{s}{\code{storm} or \code{stormsList} object.}
}
\value{
character vector.
}
\description{
The \code{getNames()} function returns the names of the storms
in a \code{storm} or a \code{stormsList} object.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the names of the storms from the sts object
getNames(sts)
}
}
