% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trivial_gradient.R
\name{trivial_gradient}
\alias{trivial_gradient}
\title{model absence of environmental gradients}
\usage{
trivial_gradient(x)
}
\arguments{
\item{x}{time/stratigraphic position at which the gradient is determined}
}
\value{
A vector of the same length as x with all entries replaced by 1.
}
\description{
Models a constant gradient with value 1. Mainly used as default input to \code{last_occ} and \code{range_offset}.
}
\examples{
x = p3(rate = 10, from = 0, to = 1) # model fossil occurrences
# apply trivial niche model
y = apply_niche(x, niche_def = trivial_niche, gc = trivial_gradient)
all(x == y) # true, no fossils were removed

}
\seealso{
\code{\link[=last_occ]{last_occ()}},  \code{\link[=range_offset]{range_offset()}}, \code{\link[=trivial_niche]{trivial_niche()}}, and \code{\link[=apply_niche]{apply_niche()}}
}
