% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-GET.R
\docType{methods}
\name{getTrades}
\alias{getTrades}
\alias{getTrades,Strategy-method}
\title{Get trades according to the signals from the \code{Strategy}-object}
\usage{
getTrades(object, from = NULL, until = NULL, which = NULL,
  of = "signals", use.backtest = FALSE)

\S4method{getTrades}{Strategy}(object, from = NULL, until = NULL,
  which = NULL, of = c("signals", "weights"), use.backtest = FALSE)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which trades shall be returned. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which trades shall be returned. If \code{NULL}, no restriction is made.}

\item{which}{Names or column-number of assets that should be included. If \code{NULL}, trades for all assets are returned.}

\item{of}{Trades to be calculated on basis of trading \code{signals} or \code{weights} of portfolio.}

\item{use.backtest}{If set to \code{TRUE}, the trades of the backtest are returned. Requires \code{\link{backtest}} to be  executed first.}
}
\description{
Gets the trades of an object of class \code{Strategy} that were performed within strategy calculation.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get price data from MA(200)-Strategy
getTrades(myStrat.MA, from="2015-01-01", until="2015-12-31")

##End(Not run)
}
