% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequential_batting.R
\name{cv.seqlr.batting}
\alias{cv.seqlr.batting}
\title{cv.seqlr.batting}
\usage{
cv.seqlr.batting(
  y,
  x,
  censor.vec = NULL,
  trt.vec = NULL,
  trtref = NULL,
  type = "c",
  n.boot = 50,
  des.res = "larger",
  class.wt = c(1, 1),
  min.sigp.prcnt = 0.2,
  pre.filter = NULL,
  filter.method = NULL,
  k.fold = 5,
  cv.iter = 50,
  max.iter = 500
)
}
\arguments{
\item{y}{data frame containing the response}

\item{x}{data frame containing the predictors}

\item{censor.vec}{vector giving the censor status (only for TTE data , censor=0,event=1) : default = NULL}

\item{trt.vec}{vector containing values of treatment variable ( for predictive signature). Set trt.vec to NULL for prognostic signature.}

\item{trtref}{code for treatment arm.}

\item{type}{data type. "c" - continuous , "b" - binary, "s" - time to event : default = "c".}

\item{n.boot}{number of bootstraps in BATTing step.}

\item{des.res}{the desired response. "larger": prefer larger response. "smaller": prefer smaller response}

\item{class.wt}{vector of length 2 used to weight the accuracy score , useful when there is class imbalance in binary data defaults to c(1,1)}

\item{min.sigp.prcnt}{desired proportion of signature positive group size for a given cutoff.}

\item{pre.filter}{NULL, no prefiltering conducted;"opt", optimized number of predictors selected; An integer: min(opt, integer) of predictors selected.}

\item{filter.method}{NULL, no prefiltering, "univariate", univaraite filtering; "glmnet", glmnet filtering, "unicart": univariate rpart filtering for prognostic case.}

\item{k.fold}{number of folds for CV.}

\item{cv.iter}{algorithm terminates after cv.iter successful iterations of cross-validation.}

\item{max.iter}{total number of iterations allowed (including unsuccessful ones).}
}
\value{
a list containing with following entries: 
\describe{
\item{stats.summary}{Summary of performance statistics.}
\item{pred.classes}{Data frame containing the predictive clases (TRUE/FALSE) for each iteration.}
\item{folds}{Data frame containing the fold indices (index of the fold for each row) for each iteration.}
\item{sig.list}{List of length cv.iter * k.fold containing the signature generated at each of the  k folds, for all iterations.}
\item{error.log}{List of any error messages that are returned at an iteration.}
\item{interplot}{Treatment*subgroup interaction plot for predictive case}
}
}
\description{
Cross Validation for Sequential BATTing
}
\details{
Cross Validation for Sequential BATTing
}
