SIMEX_S1_AFT = function(surv, status, X, Sigma_e, psi, k, dist, shape, scale) {

  ### error term distributions
  ### weibull dist
  if(dist == "weibull") {
    Phi = function(t,shape,scale) {
      y = 1 - exp(-(t/scale)^shape)
      return(y)
    }
    phi = function(t,shape,scale) {
      y = (shape/scale) *  (t/scale)^(shape-1) * exp(-(t/scale)^shape)
      return(y)
    }
    Dphi = function(t,shape,scale) {
      y = ( ((shape/scale) *  (t/scale)^(shape-1))^2 +
              ((shape*(shape-1))/scale^2) *  (t/scale)^(shape-2) ) * exp(-(t/scale)^shape)
      return(y)
    }
  }
  ###
  ### exp distribution
  if(dist == "exponential") {
    Phi = function(t,shape,scale) {
      y = 1 - exp(-(t*scale))
      return(y)
    }
    phi = function(t,shape,scale) {
      y = scale * exp(-(t*scale))
      return(y)
    }
    Dphi = function(t,shape,scale) {
      y = -scale^2 * exp(-(t*scale))
      return(y)
    }
  }
  ###
  ### logistic distribution
  if(dist == "logistic") {
    Phi = function(t,shape,scale) {
      y = 1 / (1+ exp(-((t-shape)/scale)))
      return(y)
    }
    phi = function(t,shape,scale) {
      y = exp(-((t-shape)/scale)) / (scale*(1+ exp(-((t-shape)/scale)))^2)
      return(y)
    }
    Dphi = function(t,shape,scale) {
      A = exp(-(t-shape)/scale)
      y = -scale^(-2) * A * (1+A)^(-2) + 2*scale^(-2) * A^2 * (1+A)^(-3)
      return(y)
    }
  }
  ###
  ### normal distribution
  if(dist == "normal") {
    Phi = function(t,shape,scale) {
      y = pnorm(t,shape,scale)
      return(y)
    }
    phi = function(t,shape,scale) {
      y = exp(-(t-shape)^2/(2*scale)) / sqrt(2*pi*scale)
      return(y)
    }
    Dphi = function(t,shape,scale) {
      y = (exp(-(t-shape)^2/(2*scale)) / sqrt(2*pi*scale)) * (-(t-shape)/scale)
      return(y)
    }
  }
  #############################


  ### objective function
  ell = function(response,covariate,beta,status,shape,scale) {
    y = response
    x = covariate%*%beta
    n0 = dim(covariate)[1]; p0 = dim(covariate)[2]
    a1 = (status * Dphi(y-x,shape,scale)) / phi(y-x,shape,scale)
    a2 = ((1-status) * phi(y-x,shape,scale)) / Phi(y-x,shape,scale)
    a1[which(a1=='-Inf')]=0 ; a2[which(a2=='-Inf')]=0; a1[which(is.na(a1))]=0; a2[which(is.na(a2))]=0
    return(colMeans(covariate * matrix((a1-a2),n0,p0)))
  }
  ################################


  ##### Steup
  n = dim(X)[1]
  p = dim(X)[2]
  mu_e = rep(0,p)
  Sigma_e = Sigma_e

  Y = surv; status = status
  W = X
  e = mvrnorm(n, mu_e, Sigma_e, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)
  ord.z = W + sqrt(psi) * e
  #ord.z = scale(ord.z)
  W_G = NULL
  for(k in 1:n) {
    graph =  as.numeric(ord.z[k,]) %*% t(as.numeric(ord.z[k,]))
    graph = graph - diag(diag(graph))
    W_G = rbind(W_G, c(graph))
  }
  #####################

  ###running the algorithm
  beta.ini = rep(0,p)
  theta.ini = rep(0,p^2)
  BETA = beta.ini
  THETA = theta.ini
  DIFF = c()
  dx = 0.01
  iter.max = 100
  lambda = 0.01
  dif = 1
  iter = 0

  while(dif > dx & iter <= iter.max){
    Ubeta = ell(response = log(Y) - W_G%*%theta.ini,
                covariate = ord.z,beta = beta.ini,status,shape,scale)
    id = which(abs(Ubeta) == max(abs(Ubeta)))
    beta = beta.ini
    beta[id] = beta.ini[id] + sign(Ubeta)[id]*lambda
    ####
    Utheta = ell(response = log(Y) - ord.z%*%beta,
                 covariate = W_G,beta = theta.ini,status,shape,scale)
    id_G = which(abs(Utheta) == max(abs(Utheta)))
    theta = theta.ini
    theta[id_G] = theta.ini[id_G] + sign(Utheta)[id_G]*lambda
    ####
    X_VG = cbind(ord.z,W_G)
    beta_VG = c(beta,theta)
    Ubeta_new = ell(response = log(Y), covariate = X_VG,beta = beta_VG,status,shape,scale)
    Ubeta_new[is.na(Ubeta_new)] = c(Ubeta,Utheta)[is.na(Ubeta_new)]
    dif = max(abs(Ubeta_new-Ubeta))
    DIFF = c(DIFF,dif)
    iter = iter + 1
    beta.ini = beta
    theta.ini = theta
    BETA = rbind(BETA,beta.ini)
    THETA = rbind(THETA,theta.ini)
  }

  #BETA

  return(  c(beta.ini, theta.ini) )




}
