library(GGally)

VS_network = function(beta,theta,labels,label.sizes=6,node.size=6) {

if(missing(labels)) { labels = c(1:length(beta)) }
net <- network(theta, directed = FALSE)
graph = GGally::ggnet2(net,size=node.size,node.color = "lightgray",
label=labels, label.size=label.sizes,mode = "circle")

id = which(beta !=0)

estimator = list(labels[id], graph)
names(estimator) = c("selected_variables", "graph")

return(estimator)

}
