% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_randomGenerationFunctions.R
\name{rLifes}
\alias{rLifes}
\alias{rLife}
\alias{rLifexyz}
\title{Function to generate random future lifetimes}
\usage{
rLife(n, object, x = 0, k = 1, type = "Tx")

rLifexyz(n, tablesList, x, k = 1, type = "Tx")
}
\arguments{
\item{n}{Number of variates to generate}

\item{object}{An object of class lifetable}

\item{x}{The attained age of subject x, default value is 0}

\item{k}{Number of periods within the year when it is possible death to happen, default value is 1}

\item{type}{Either \code{"Tx"} for continuous future lifetime, \code{"Kx"} for curtate furture lifetime (can be abbreviated).}

\item{tablesList}{An list of lifetables}
}
\value{
A numeric vector of n elements.
}
\description{
Function to generate random future lifetimes
}
\details{
Following relation holds for the future life time: \eqn{T_x=K_x+0.5}
}
\note{
The function is provided as is, without any warranty regarding the accuracy of calculations. The author disclaims any liability for eventual 	losses arising from direct or indirect use of this software.
}
\examples{
\dontrun{
##get 20000 random future lifetimes for the Soa life table at birth
data(soa08Act)
lifes=rLife(n=20000,object=soa08Act, x=0, type="Tx")
check if the expected life at birth derived from the life table is statistically equal 
to the expected value of the sample
t.test(x=lifes, mu=exn(soa08Act, x=0, type="continuous"))
}
\dontrun{
#assessment of curtate expectation of future lifetime of the joint-life status
#generate a sample of lifes
data(soaLt)
soa08Act=with(soaLt, new("actuarialtable",interest=0.06,x=x,lx=Ix,name="SOA2008"))
tables=list(males=soa08Act, females=soa08Act)
xVec=c(60,65)
test=rLifexyz(n=50000, tablesList = tables,x=xVec,type="Kx")
#check first survival status
t.test(x=apply(test,1,"min"),mu=exyzt(tablesList=tables, x=xVec,status="joint"))
#check last survival status
t.test(x=apply(test,1,"max"),mu=exyzt(tablesList=tables, x=xVec,status="last"))
}
}
\references{
Actuarial Mathematics (Second Edition), 1997, by Bowers, N.L., Gerber, H.U., Hickman, J.C., Jones, D.A. and Nesbitt, C.J.
}
\seealso{
\code{\linkS4class{lifetable}}, \code{\link{exn}}
}
