% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETM.R
\name{as.matrix.ETM}
\alias{as.matrix.ETM}
\title{Get matrices out of an ETM object}
\usage{
\method{as.matrix}{ETM}(x, type = c("embedding", "beta"), which = c("topics", "words"), ...)
}
\arguments{
\item{x}{an object of class \code{ETM}}

\item{type}{character string with the type of information to extract: either 'beta' (words emttied by each topic) or 'embedding' (embeddings of words or topic centers). Defaults to 'embedding'.}

\item{which}{a character string with either 'words' or 'topics' to get either the embeddings of the words used in the model or the embedding of the topic centers. Defaults to 'topics'. Only used if type = 'embedding'.}

\item{...}{not used}
}
\value{
a numeric matrix containing, depending on the value supplied in \code{type} 
either the embeddings of the topic centers, the embeddings of the words or the words emitted by each topic
}
\description{
Convenience function to extract 
\itemize{
\item{embeddings of the topic centers}
\item{embeddings of the words used in the model}
\item{words emmitted by each topic (beta), which is the softmax-transformed inner product of word embedding and topic embeddings}
}
}
\examples{
\dontshow{if(require(torch) && torch::torch_is_installed())
\{
}
library(torch)
library(topicmodels.etm)
path  <- system.file(package = "topicmodels.etm", "example", "example_etm.ckpt")
model <- torch_load(path)

topic.centers     <- as.matrix(model, type = "embedding", which = "topics")
word.embeddings   <- as.matrix(model, type = "embedding", which = "words")
topic.terminology <- as.matrix(model, type = "beta")
\dontshow{
\}
# End of main if statement running only if the torch is properly installed
}
}
\seealso{
\code{\link{ETM}}
}
