% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tad.R
\name{generate_random_matrix}
\alias{generate_random_matrix}
\title{Generate random matrix}
\usage{
generate_random_matrix(
  weights,
  aggregation_factor = NULL,
  randomization_number,
  seed = NULL
)
}
\arguments{
\item{weights}{the dataframe of weights, one row correspond to a
series of observation}

\item{aggregation_factor}{the dataframe of factor to take into account for
the randomization}

\item{randomization_number}{the number of random abundance matrix to
generate}

\item{seed}{the seed of the pseudo random number generator}
}
\value{
a data.frame of randomization_number observations
}
\description{
Generate and save random matrix
}
\examples{
aggregation_factor_name <- c("Year", "Bloc")
weights_factor = TAD::AB[, c("Year", "Plot", "Treatment", "Bloc")]
aggregation_factor <- as.data.frame(
  weights_factor[, aggregation_factor_name]
)
random_matrix <- TAD::generate_random_matrix(
  weights = TAD::AB[, 5:102],
  aggregation_factor = aggregation_factor,
  randomization_number = 100,
  seed = 1312
)
head(random_matrix)
}
\concept{tad}
