% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lim.R
\name{lim}
\alias{lim}
\title{Axis Limits}
\usage{
lim(x, mult = 1.1)
}
\arguments{
\item{x}{a vector of data values.}

\item{mult}{a number to multiply with the highest data value.}
}
\value{
A vector of length two, which can be used as axis limits.
}
\description{
Compute reasonable axis limits for plotting non-negative numbers.
}
\note{
The lower limit is set to 0, and the upper limit is determined by the highest
data value, times a multiplier.
}
\examples{
plot(precip)
plot(precip, ylim=lim(precip))
plot(precip, ylim=lim(precip), yaxs="i")

}
\seealso{
\code{\link{TAF-package}} gives an overview of the package.
}
