% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILT.R
\name{ILT}
\alias{ILT}
\title{numerical method to compute inverse of Laplace Transform}
\usage{
ILT(
  FUNCT,
  t,
  nterms = 31L,
  m = 1,
  gamma = 0.5,
  fail_val = complex(0),
  msg = TRUE
)
}
\arguments{
\item{FUNCT}{function object F(z), typically a Laplace Transform of a function f(t)}

\item{t}{time domain value to evaluate the ILT(F)(t)}

\item{nterms}{number of terms to use in the numerical inversion (odd number). The default is 31L.}

\item{m}{width of the contour path in C; too small values may lead to singularities on the negative x-axis; 
too large valued may lead to numerical instability for large positive x-axis. The default is 1.}

\item{gamma}{value on the positive x-axis for the vertical line representing the contour. The default is 0.5}

\item{fail_val}{value to return in event of failure to converge}

\item{msg}{Boolean to show/hide warnings. The default is TRUE.}
}
\value{
a real value computed from inverse Laplace Transform
}
\description{
a function that numerically computes the inverse of Laplace Transform
}
\details{
This function first uses full optimum contour path to do inverse Laplace Transform.
However, if this method fails, the function will automatically change to the method 
of using Bromwich contour path to do inverse Laplace Transform
}
\examples{
# analytic form of Laplace transform of f(t) = t
F = function(z) { 1/(z^2) }
# do inverse Laplace transform on t = 0.2
ILT(F, t = 0.2)
# the result is equal to t = 0.2
}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
