#' @title The Transition Diagnostic Classification Model Framework
#'
#' @description For conducting longitudinal DCM analysis within the TDCM
#' framework.
#'
#' @details Diagnostic classification models (DCMs) are psychometric models
#' designed to classify examinees according to their proficiency on a set of
#' categorical latent traits, known as attributes. Longitudinal DCMs have been
#' developed as psychometric options for modeling changes in attribute
#' proficiency over time.
#'
#' The TDCM package implements estimation of the transition DCM (TDCM;
#' Madison & Bradshaw, 2018a), a longitudinal extension of the log-linear
#' cognitive diagnosis model (LCDM; Henson, Templin, & Willse, 2009). As the
#' LCDM subsumes many other DCMs, many other DCMs can be estimated
#' longitudinally via the TDCM. The package includes functions to estimate the
#' single-group and multigroup TDCM, summarize results of interest including
#' item parameters, growth proportions, transition probabilities, transitional
#' reliability, attribute correlations, model fit, and growth plots.
#'
#' @author Matthew J. Madison, University of Georgia, mjmadison@@uga.edu
#' @author Sergio Haab, University of Iowa
#' @author Minjeong Jeon, University of California - Los Angeles
#' @author Michael E. Cotterell, University of Georgia
#'
#' @references
#' de la Torre, J. (2011). The generalized DINA model framework. Psychometrika, 76, 179-199.
#'
#' George, A. C., Robitzsch, A., Kiefer, T., Gross, J., & Ünlü , A. (2016). The R package CDM for cognitive diagnosis models. Journal of Statistical Software, 74(2), 1-24.
#'
#' Henson, R., Templin, J., & Willse, J. (2009). Defining a family of cognitive diagnosis models using log linear models with latent variables. Psychometrika, 74, 191-21.
#'
#' Johnson, M. S., & Sinharay, S. (2020). The reliability of the posterior probability of skill attainment in diagnostic classification models. Journal of Educational Measurement, 47(1), 5 – 31.
#'
#' Kaya, Y., & Leite, W. (2017). Assessing change in latent skills across time with longitudinal cognitive diagnosis modeling: An evaluation of model performance. Educational and Psychological Measurement, 77(3), 369–388.
#'
#' Li, F., Cohen, A., Bottge, B., & Templin, J. (2015). A latent transition analysis model for assessing change in cognitive skills. Educational and Psychological Measurement, 76(2), 181–204.
#'
#' Madison, M. J. (2019). Reliably assessing growth with longitudinal diagnostic classification models. Educational Measurement: Issues and Practice, 38(2), 68-78.
#'
#' Madison, M. J., & Bradshaw, L. (2018a). Assessing growth in a diagnostic classification model framework. Psychometrika, 82(4), 963-990.
#'
#' Madison, M. J., & Bradshaw, L. (2018b). Evaluating intervention effects in a diagnostic classification model framework. Journal of Educational Measurement, 55(1), 32-51.
#'
#' Madison, M.J., Chung, S., Kim, J. et al. Approaches to estimating longitudinal diagnostic classification models. Behaviormetrika (2023).
#'
#' Rupp, A. A., Templin, J., & Henson, R. (2010). Diagnostic measurement: Theory, methods, and applications. New York: Guilford.
#'
#' Schellman, M., & Madison, M. J. (2021, July). Estimating the reliability of skill transition in longitudinal DCMs. Paper presented at the 2021 International Meeting of the Psychometric Society.
#'
#' Templin, J., & Bradshaw, L. (2013). Measuring the reliability of diagnostic classification model examinee estimates. Journal of Classification, 30, 251-275.
#'
#' Wang. S., Yang. Y., Culpepper, S. A., & Douglas, J. (2018). Tracking Skill Acquisition with cognitive diagnosis models: A higher-order, hidden Markov model with covariates. Journal of  Educational and Behavioral Statistics, 43(1), 57-87.
#'
#' @keywords internal
#' @aliases TDCM-package NULL
#' @docType package
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
