% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tmax.R
\name{Tmaxplot}
\alias{Tmaxplot}
\title{Plot the Tmax}
\usage{
Tmaxplot(df)
}
\arguments{
\item{df}{Data frame containing Tmax, identification of sub-groups and DOY.}
}
\value{
Return a plot of Tmax by days for each sub-group
}
\description{
Plot the Tmax with indications of extreme values
}
\details{
The dataframe should contain at least 3 columns named "Tmax" (daily maximums of tension), "DOY" (day of the year) and "ID" (sub-groups). The red horizontal lines reprensents 3 times the inter-quartile range (3*IQR) of all the Tmax of the data. The blue horizontal line reprensent the 1.5*IQR without the Tmax outside the red lines.
}
\examples{
DOY = c(rep(102, times=10), rep(103, times=10))
ID = c(rep("A", times=5), rep("B", times=5), rep("A", times=5), rep("B", times=5))
Tmax = c(rep(0.7512, times=5), rep(0.7359, times=5),rep(0.7644, times=5),rep(0.7666, times=5))
df <- data.frame(DOY, ID, Tmax, stringsAsFactors = FALSE)
Tmaxplot(df)
}
