% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tmax.R
\name{remove.fun}
\alias{remove.fun}
\title{Remove unwanted dates}
\usage{
remove.fun(df, dates)
}
\arguments{
\item{df}{Data frame containing a DOY column named "DOY".}

\item{dates}{Character vector containing the DOY to remove from the data frame.}
}
\value{
Return the inputed data frame without the date corresponding the the "dates" argument.
}
\description{
Remove all data for the corresponding date argument
}
\details{
This function is primarely used to remove days for which Tmax is too extreme.
}
\examples{
DOY = c(rep(102, times=10), rep(103, times=10))
ID = c(rep("A", times=5), rep("B", times=5), rep("A", times=5), rep("B", times=5))
Tmax = c(rep(2.5, times=5), rep(2.7, times=5), rep(3.2, times=5), rep(3.4, times=5))
df <- data.frame(DOY, ID, Tmax)
dates = c("103")
remove.fun(df=df, dates=dates) 
}
