% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaflowCalc.R
\name{tens.to.sapflow}
\alias{tens.to.sapflow}
\title{Convert tension into sap flow density}
\usage{
tens.to.sapflow(tension, Tmax)
}
\arguments{
\item{tension}{Vector with tension.}

\item{Tmax}{Vector with corresponding maximums of tension.}
}
\value{
Return a numerical vector containing the sap flow density
}
\description{
Use the Granier formula to convert tension into sap flow density using daily or mean Tmax
}
\examples{
Tmax = c(rep(2.5, times=5), rep(2.7, times=5), rep(3.2, times=5), rep(3.4, times=5))
tension = c(5:25)
tens.to.sapflow(tension=tension, Tmax=Tmax)
}
\references{
Granier A. 1985. A new method of sap flow measurement in tree stems. Annales Des Sciences Forestieres 42(2): 193-200.

Granier A. 1987. Evaluation of transpiration in a douglas-fir stand by means of sap flow measurements. Tree Physiology 3(4): 309-319.
}
