% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OriginalFunctions.R
\name{Opt.nonpar.rule}
\alias{Opt.nonpar.rule}
\title{Optimal Nonparametric Rule}
\usage{
Opt.nonpar.rule(Z, S, phi, lambda)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}

\item{phi}{Percentage of patients taking viral load test.}

\item{lambda}{A user-specified weight that reflects relative loss for the two types of misdiagnoses, taking value in \eqn{[0,1]}. \eqn{Loss=\lambda*I(FN)+(1-\lambda)*I(FP)}.}
}
\value{
Optimal nonparametric rule and its associated misclassification rates (FNR, FPR), optimal lambda risk, and total misclassification rate (TMR).
}
\description{
This function gives you the optimal nonparametric tripartite rule that minimizes the min-\eqn{\lambda} rules.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
lambda = 0.5
Opt.nonpar.rule( Z, S, phi, lambda)
}
\keyword{nonparametric}
\keyword{rules}
