% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.tpolytope.R
\name{draw.tpolytope}
\alias{draw.tpolytope}
\alias{draw.tpolytope.3d}
\alias{draw.tpolytope.2d}
\title{Draw a 2-D or 3-D tropical polytope}
\usage{
draw.tpolytope.3d(D, col_lines, col_verts, plot = TRUE, tadd = max)

draw.tpolytope.2d(D, col_lines, col_verts, plot = TRUE, tadd = max)
}
\arguments{
\item{D}{matrix of vertices of a tropical polytope; rows are the vertices}

\item{col_lines}{string; color to render the polytope.}

\item{col_verts}{string; color to render the vertices.}

\item{plot}{logical; initiate new plot visualization or not.}

\item{tadd}{function; max indicates max-plus addition, min indicates min-plus
addition. Defaults to max}
}
\value{
2-D or 3-D rendering of a tropical polytope.
}
\description{
This command draws a three dimensional tropical polytope
}
\examples{
D <-matrix(c(0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),4,4,TRUE)
col_lines<-'blue'
col_verts<-'red'
draw.tpolytope.3d(D,col_lines,col_verts,plot=TRUE)
draw.tpolytope.3d(D,col_lines,col_verts,plot=TRUE,tadd=min)

D <- matrix(c(0,-2,2,0,-2,5,0,2,1,0,1,-1),4,3,TRUE)
col_lines <- 'blue'
col_verts <- 'red'
draw.tpolytope.2d(D,col_lines,col_verts,plot=TRUE)
draw.tpolytope.2d(D,col_lines,col_verts,plot=TRUE,tadd=min)

}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
