% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSTORDs.R
\name{NSTORDs}
\alias{NSTORDs}
\title{Non-Sequential Third Order Rotatable Designs}
\usage{
NSTORDs(v, randomization = FALSE)
}
\arguments{
\item{v}{Number of input factors, v (3<=v<=15)}

\item{randomization}{It is for generating the randomized layout of the design. It takes either TRUE or FALSE and by default, it is set to FALSE}
}
\value{
Non-Sequential Third Order Rotatable Designs (NSTORDs) for a given v.
}
\description{
This function generates non sequential third order rotatable designs given in Das and Narasimham (1962) for a given number of input factors, v (3<=v<=15) with coded levels of the factors. It also gives the randomized layout of the design.
}
\examples{
library(TORDs)
NSTORDs(4,FALSE)
}
\references{
1) Das, M. N., and V. L. Narasimham (1962). <DOI:10.1214/aoms/1177704374>. "Construction of rotatable designs through balanced incomplete block designs".

2)M. Hemavathi, Eldho Varghese, Shashi Shekhar & Seema Jaggi (2022)<DOI:10.1080/02664763.2020.1864817>." Sequential asymmetric third order rotatable designs (SATORDs)".

3) M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<DOI: 10.1080/03610926.2021.1944213>." Theoretical developments in response surface designs: an informative review and further thoughts".
}
