% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPP.R
\name{TPP}
\alias{TPP}
\title{True positive proportion (TPP)}
\usage{
TPP(beta_hat, beta, eps = .Machine$double.eps)
}
\arguments{
\item{beta_hat}{Estimated regression coefficient vector.}

\item{beta}{True regression coefficient vector.}

\item{eps}{Numerical zero.}
}
\value{
True positive proportion (TPP).
}
\description{
Computes the TPP based on the estimated and the true regression coefficient vectors.
}
\examples{
data("Gauss_data")
X <- Gauss_data$X
y <- c(Gauss_data$y)
beta <- Gauss_data$beta

set.seed(1234)
res <- trex(X, y)
beta_hat <- res$selected_var

TPP(beta_hat = beta_hat, beta = beta)
}
