% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSEind.R
\name{SMAPEi}
\alias{SMAPEi}
\title{Symmetric mean absolte percentage error (SMAPE)}
\usage{
SMAPEi(Actual1, Survey1, ...)
}
\arguments{
\item{Actual1}{data from a "gold standard" survey; data are assumed to be the "actual" response, without survey error}

\item{Survey1}{data from another survey, but with survey error; function will calculate SMAPE for this survey}

\item{...}{used for additional surveys with survey error, survey 2 through survey #}
}
\value{
Matrix with SMAPE values for survey 1 through survey #
}
\description{
Calculates SMAPE when Actual# and Survey# have independent samples
}
\note{
Make sure to properly order inputs, per the example: for each survey, inputs
must be paired as Actual#, Survey#, and each pair given in sequential order
}
\examples{
SMAPEi(Actual1=TESTIND$A1, Survey1=TESTIND$S1, Actual2=TESTIND$A1, Survey2=TESTIND$S2,
Actual3=TESTIND$A2, Survey3=TESTIND$S3)
}
