% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastSampEn_C.R
\name{FastSampEn}
\alias{FastSampEn}
\title{FastSampEn}
\usage{
FastSampEn(TS, dim = 2, lag = 1, r = 0.15 * sd(TS))
}
\arguments{
\item{TS}{- given time series}

\item{dim}{- dimension of given time series, default value is 2}

\item{lag}{- downsampling, default value is 1}

\item{r}{- radius of searched areas, default value is 0.15*sd(TS)}
}
\description{
This function computes fast sample entropy of given time series.
}
\examples{
timser <- rnorm(2000)
FastSampEn(timser)
FastSampEn(timser, r = 0.1*sd(timser))
FastSampEn(timser, dim = 3, r = 0.1*sd(timser))

}
\keyword{FastSampEn}
\keyword{entropy}
\keyword{fast}
\keyword{sample}
