% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSEwgt.R
\name{AVERMSEw}
\alias{AVERMSEw}
\title{Average root mean squared error (aRMSE)}
\usage{
AVERMSEw(Actual = data.frame(), Survey = data.frame(),
  Weights = data.frame())
}
\arguments{
\item{Actual}{data from a "gold standard" survey; objects are variable columns
from "gold standard" survey that corruspond to variable columns Survey}

\item{Survey}{data from a survey; objects are variable columns from a
survey that corruspond to variable columns from Actual}

\item{Weights}{weights to be applied to Survey data; objects are weights columns}
}
\value{
Average root mean squared error (aRMSE) under multiple, different weighting schemes
}
\description{
Calculates average root mean squared error (aRMSE) under multiple, different weighting schemes
}
\details{
aRMSE for weighting scheme # => mean value of the RMSEs for specified variables
under weighting scheme # => mean value of RMSEs for objects in Survey=data.frame() *
objects in Weights=data.frame()
}
\note{
Make sure to properly order inputs, per the example: Actual=data.frame() objects
and corrusponding Survey=data.frame() objects must be given in the same order as each other;
and Weights=data.frame() objects must be given in sequence of weighting scheme #.
}
\examples{
AVERMSEw(Actual=data.frame(TESTWGT$A1, TESTWGT$A2),
Survey=data.frame(TESTWGT$Q1, TESTWGT$Q2),
Weights=data.frame(TESTWGT$W1, TESTWGT$W2))
}
