% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSLSTM.R
\name{summary.LSTMModel}
\alias{summary.LSTMModel}
\title{Summary of a Trained LSTM Model}
\usage{
\method{summary}{LSTMModel}(object, ...)
}
\arguments{
\item{object}{An LSTMModel object containing a trained LSTM model along with normalization parameters and lag values.}

\item{...}{Optional arguments, no use is contemplated right now}
}
\value{
A vector containing the forecasted values for the specified horizon.
}
\description{
This function generates the summary of the LSTM model.
}
\examples{
\donttest{
  if (keras::is_keras_available()){
      y<-rnorm(100,mean=100,sd=50)
      x1<-rnorm(100,mean=50,sd=50)
      x2<-rnorm(100, mean=50, sd=25)
      x<-cbind(x1,x2)
      TSLSTM<-ts.lstm(ts=y,
                      xreg = x,
                      tsLag=2,
                      xregLag = 0,
                      LSTMUnits=5,
                      ScaleInput = 'scale',
                      ScaleOutput = 'scale',
                      Epochs=2)
      # Assuming TSLSTM is an LSTMModel object created using ts.lstm function
      summary(TSLSTM)
  }
}

}
