# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' make_swc
#'
#' Creates soil water content index from input precipitation,
#' potential evapotranspiration, field capacity and wilting point.
#'
#' This function is called internally by \code{get_input()}.
#'
#' @param pet matrix with ntimesteps rows, nsites columns, containing potential evapotranspiration [kg*m^(-2)*s^(-1)]
#' @param rain matrix with ntimesteps rows, nsites columns, containing precipitation [kg*m^(-2)*s^(-1)]
#' @param wp vector of length nsites containing the wilting point [cm^3/cm^3]
#' @param fc vector of length nsites containing the field capacity [cm^3/cm^3]
#' @param seconds number of seconds in a time step
#' @param iterations number of times to run through the data, default is 3
#' @return matrix with ntimesteps rows, nsites columns, containing a soil water content index scaled from 0-100 
#' @export
make_swc <- function(rain, pet, fc, wp, seconds, iterations) {
    .Call(`_TTR_PGM_make_swc`, rain, pet, fc, wp, seconds, iterations)
}

interval_c <- function(v, b) {
    .Call(`_TTR_PGM_interval_c`, v, b)
}

run_ttr_cpp <- function(ttr_parameters, timeseries, timeinvariant, options, globals) {
    .Call(`_TTR_PGM_run_ttr_cpp`, ttr_parameters, timeseries, timeinvariant, options, globals)
}

varnames <- function(x) {
    .Call(`_TTR_PGM_varnames`, x)
}

#' calc_photo
#'
#' Generates estimates of photosynthetic rates using a Farquar type photosynthesis model.
#'
#' This function is called internally by \code{get_input()}.
#'
#' @param leaf_temp  matrix with ntimesteps rows, nsites columns, containing leaf temperature [°C]
#' @param photo_active_rad  matrix with ntimesteps rows, nsites columns, containing photosynthetically active radiation [umol*m^(-2)*s^(-1)]
#' @param atmospheric_co2 matrix with ntimesteps rows, nsites columns, containing atmospheric CO2 partial pressure [Pa]
#' @param ppl a list of photosynthetic parameters (see \code{p3} and \code{p4})
#' @param pht a string indicating "c3" or "c4" photosynthesis
#' @return matrix with ntimesteps rows, nsites columns, containing the calculated photosynthetic rates [umol*m^(-2)*s^(-1)]
#' @export
calc_photo <- function(leaf_temp, photo_active_rad, atmospheric_co2, ppl, pht) {
    .Call(`_TTR_PGM_calc_photo`, leaf_temp, photo_active_rad, atmospheric_co2, ppl, pht)
}

