% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convexcheck.R
\name{convexcheck}
\alias{convexcheck}
\title{Convex check}
\usage{
convexcheck(v, binary = FALSE, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if the game is convex, \code{FALSE} otherwise. If \code{instance=TRUE} and the game is not convex, the function also returns the positions (binary order positions if \code{binary=TRUE}; lexicographic order positions otherwise) of a pair of coalitions violating the Zumsteg convexity characterization.
}
\description{
This function checks if the given game is convex.
}
\details{
A game \eqn{v\in G^N} is convex if \eqn{v(S \cap T) + v(S \cup T) \ge v(S)+v(T)} for all
\eqn{S,T \in 2^N}. Zumsteg, S. (1995) shows that \eqn{v} is convex if \eqn{v(S \cup {i}\cup {j}) + v(S) \ge v(S\cup {i})+v(S\cup {j})} for all
\eqn{S\in 2^N} and \eqn{i,j\in N\backslash S} such that \eqn{i\not=j}.

A game \eqn{v\in G^N} is concave if \eqn{-v} is convex.
}
\examples{
v1 <- c(5, 2, 2, 1, 8, 8, 6, 4, 3, 3, 12, 10, 10, 6, 14)
convexcheck(v1)
v2 <- c(0, 0, 0, 2, 2, 1, 3)
convexcheck(v2, binary = FALSE, instance = TRUE)

# How to check if a game is concave:
v.conc <- c(4, 3, 3, 2, 6, 6, 5, 5, 4, 4, 7, 6, 6, 6, 7) # concave game
convexcheck(-v.conc)
}
\references{
Zumsteg, S. (1995). \emph{Non-cooperative aspects of cooperative game theory and related computational problems}. PhD thesis, ETH Zurich.
}
\seealso{
\link{strategicallyequivalentcheck}, \link{superadditivecheck}
}
