% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degeneratecheck.R
\name{degeneratecheck}
\alias{degeneratecheck}
\title{Degenerate check}
\usage{
degeneratecheck(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
\code{TRUE} if the game is degenerate, \code{FALSE} otherwise.
}
\description{
This function checks if the given game is degenerate.
}
\details{
A game \eqn{v\in G^N} is degenerate if \eqn{v(N)=\sum_{i \in N} v(i)}.
}
\examples{
v <- c(1, 5, 10, 0, 0, 0, 16)
degeneratecheck(v)
w <- c(1, 5, 10, 0, 0, 0, 15)
degeneratecheck(w)
}
\seealso{
\link{essentialcheck}
}
