% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleoluspcvalue.R
\name{nucleoluspcvalue}
\alias{nucleoluspcvalue}
\title{Per capita nucleolus}
\usage{
nucleoluspcvalue(v, binary = FALSE, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
The per capita nucleolus of the game, as a vector.
}
\description{
Given a game, this function computes its per capita nucleolus.
}
\details{
Given a game \eqn{v\in G^N} and an allocation \eqn{x \in I(v)}, the per capita excess
of each coalition \eqn{S \in 2^{N}} with respect to \eqn{x} is defined as
\deqn{e^{p}(v,x,S) = \frac{v(S)-\sum_{i \in S}x_{i}}{|S|}.}
The per capita excesses of all non-empty coalitions, sorted in non-increasing order, are stored
in the per capita excesses vector, \eqn{\theta^{p}(x)}.
For any game \eqn{v\in G^N} with a non-empty set of imputations, the per capita nucleolus
is defined as the only imputation \eqn{pcn(v) \in I(v)} that satisfies
\eqn{\theta^{p}(pcn(v))_{i} \leqslant \theta^{p}(y)_{i}} for each \eqn{i \in \{1,\dots,2^{N}-1\}}
and for all \eqn{y \in I(v)}.
This function is programmed following the algorithm of Potters, J.A., et al. (1996).
}
\examples{
nucleoluspcvalue(c(1,5,10,6,11,15,16))
nucleoluspcvalue(c(0,0,0,30,30,80,100))

# Computing the per capita nucleolus of a random essential game:
n <- 10 # number of players in the game
v <- c(rep(0,n),runif(2^n-(n+1),min=10,max=20)) # random essential game
nucleoluspcvalue(v)

# What if the game is a cost game?
cost.v <- airfieldgame(c(1,5,10,15)) # cost game
-nucleoluspcvalue(-cost.v) # per capita nucleolus of the cost game
}
\references{
Grotte, J. (1970). \emph{Computation of and Observations on the Nucleolus, the Normalized Nucleolus and the Central Games}. Master’s thesis), Cornell University, Ithaca.

Potters, J. A., Reijnierse, J. H., & Ansing, M. (1996). Computing the nucleolus by solving a prolonged simplex algorithm. \emph{Mathematics of Operations Research}, 21(3), 757-768.
}
\seealso{
\link{excesses}, \link{leastcore}, \link{nucleolusvalue}, \link{prenucleolusvalue}
}
