% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TabaGpartial.R
\name{taba.gpartial}
\alias{taba.gpartial}
\title{Generalized Taba Partial and Taba Rank Partial Correlation}
\usage{
taba.gpartial(x, y, xcov, ycov, regress.x, regress.y,
              method = c("taba","tabarank","tabwil","tabwilrank"),
              alternative = c("less", "greater", "two.sided"),
              omega)
}
\arguments{
\item{x}{A numeric vector of length greater than 2 must be same length as y and covariates
listed in x and ycov}

\item{y}{A numeric vector of length greater than 2 must be same length as x and covariates
listed in y and xcov}

\item{xcov}{A data frame, matrix, or numeric vectors combined columnwize used as covariates for x,
which have length equal to x}

\item{ycov}{A data frame, matrix, or numeric vectors combined columnwize used as covariates for y,
which have length equal to y}

\item{regress.x}{A string variable "\code{linear}" for linear regression, "\code{logistic}" for binary
logistic regression, and "\code{poisson}" for Poisson regression}

\item{regress.y}{A string variable "\code{linear}" for linear regression, "\code{logistic}" for binary
logistic regression, and "\code{poisson}" for Poisson regression}

\item{method}{A character string of \code{"taba"}, \code{"tabarank"}, \code{"tabwil"}, or
\code{"tabwilrank"} determining if one wants to calculate Taba linear, Taba rank
(monotonic), TabWil, or TabWil rank correlation, respectively. If no method is specified,
the function will output Taba Linear correlation.}

\item{alternative}{Character string specifying the alternative hypothesis must be one
of \code{"less"} for negative association, \code{"greater"} for
positive association, or \code{"two.sided"} for difference in association.
If the alternative is not specified, the function will default to a two sided test.}

\item{omega}{Numeric allowing the user to alter the tuning constant. If one is not specified,
the function will default to 0.45 for Taba and Taba rank, and 0.1 for TabWil and TabWil rank.
Range is between 0 and 1.}
}
\value{
This function returns the robust association
  between two numeric vectors, adjusting for specified covariates. In addition,
  this function can provide the semipartial correlation, if specified.
}
\description{
Calculates a generalized partial correlation using one of the
   specified robust methods Taba linear or Taba rank correlation.
}
\details{
This function generalizes the partial correlation. In the event that the controlling
   variables for x and y are identical, it reduces to Taba, Taba rank, TabWil, and TabWil
   rank partial correlation. Covariates used to control for x
   should be represented columnwise in a matrix or data frame as \code{xcov}. Similarly,
   covariates used to control for y should be represented columnwise in a matrix or
   data frame as \code{ycov}. When controling an outcome variable with one covariate,
   a vector will suffice. Because x and y refer to the outcome varibales, names of
   covariates (or control variables) must not be named "x" or "y". The user has the
   option of using different regression methods when controling each outcome variable.
   Missing values in x, y, or any of the covariates are deleted row-wise. All categorical
   variables must be converted to type factor prior to using this function. \cr
   The default for this function is a two sided test using generalized partial Taba
   correlation using a linear regression to obtain residuals, with the tuning
   constant \code{omega} equal to 0.45.
}
\examples{
x = rnorm(100)
y = rnorm(100)
z1 = rnorm(100)
z2 = rnorm(100)
z3 = rnorm(100)
w = sample(c(0,1), replace=TRUE, size=100)
taba.gpartial(x, y, xcov = cbind(z1, z2), ycov = cbind(z1, z3), method = "tabarank")
taba.gpartial(x, y, z2, ycov = cbind(z1, z2), alternative = "less")
taba.gpartial(w, y, z1, cbind(z2, z3),regress.x = "logistic")
}
\references{
Tabatabai, M., Bailey, S., Bursac, Z. et al. An introduction to new robust linear
  and monotonic correlation coefficients. BMC Bioinformatics 22, 170 (2021). https://doi.org/10.1186/s12859-021-04098-4
  \cr{\cr{\doi{https://doi.org/10.1186/s12859-021-04098-4}}}
}
\seealso{
\code{\link{taba}} for calculating Taba linear or Taba rank (monotonic) correlations
  \cr\code{\link{taba.test}} for testing Taba linear or Taba rank Monotonic correlations
  \cr\code{\link{taba.partial}} for partial and semipartial correlations
  \cr\code{\link{taba.matrix}} for calculating correlation, p-value, and distance matricies
}
