% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TailID.R
\name{TailID}
\alias{TailID}
\title{Detects the sensitive points in the Tail}
\usage{
TailID(sample, pm_max, pm_min, pc_max, pc_min, conf_level)
}
\arguments{
\item{sample}{A numeric vector.}

\item{pm_max}{A number between 0 and 1 indicating the threshold of maximum extreme values to consider.}

\item{pm_min}{A number between 0 and 1 indicating the threshold of minimum extreme values to consider.}

\item{pc_max}{A number between pm_max and 1  indicating the threshold of maximum sensitive points to consider.}

\item{pc_min}{A number between pm_min and 1 indicating the threshold of minimum sensitive points to consider.}

\item{conf_level}{A number between 0 and 1 indicating the confidence level for the detection.}
}
\value{
A vector of indices corresponding to the detected sensitive points.
}
\description{
This function returns the points of the tail that are inconsistent with the ID hypothesis.
}
\examples{
TailID(rnorm(1000), 0.8, 0.8, 0.99, 0.99, 0.95)
TailID(c(rnorm(10^3,10,1),rnorm(10,20,3)), 0.8, 0.8, 0.9, 0.9, 0.9999)
}
