% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_evaluation.R
\name{shape_evaluation}
\alias{shape_evaluation}
\title{Evaluation of the shape parameter to return inconsistent points and shape parameters computed and its confidence intervals}
\usage{
shape_evaluation(sample, candidates, pm_max, pm_min, conf_level)
}
\arguments{
\item{sample}{A numeric vector.}

\item{candidates}{A list of indices of the sample.}

\item{pm_max}{A number between 0 and 1 indicating the threshold of maximum extreme values to consider.}

\item{pm_min}{A number between 0 and 1 indicating the threshold of maximum extreme values to consider.}

\item{conf_level}{A number between 0 and 1 indicating the confidence level for the detection.}
}
\value{
A vector of indices corresponding to the detected sensitive points.
}
\description{
This function detects the points of the tail that are inconsistent with the ID hypothesis by evaluation the shape variation of the GPD,
and also returns the shape parameters computed and its confidence intervals
}
\examples{
shape_evaluation(rnorm(1000),candidate_selection(rnorm(1000), 0.99, 0.99),
 0.8, 0.8, 0.95)
shape_evaluation(c(rnorm(10^3,10,1),rnorm(10,20,3)),
candidate_selection(c(rnorm(10^3,10,1),rnorm(10,20,3)), 0.9, 0.9),
0.8, 0.8, 0.9999)
}
