% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{qTSS}
\alias{qTSS}
\title{Quantile function of the tempered stable subordinator distribution}
\usage{
qTSS(
  p,
  alpha = NULL,
  delta = NULL,
  lambda = NULL,
  theta = NULL,
  qmin = NULL,
  qmax = NULL,
  ...
)
}
\arguments{
\item{p}{A numeric vector of probabilities. Each probability must be a real
number >0 and <1.}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambda}{Tempering parameter. A real number > 0.}

\item{theta}{Parameters stacked as a vector.}

\item{qmin, qmax}{Limits of the interval. Will be computed if
\code{==NULL}.}

\item{...}{Modify \code{\link[=pTSS]{pTSS()}} and \code{\link[stats:uniroot]{stats::uniroot()}}.}
}
\value{
As \code{p} is a numeric vector, the return value is also a numeric
vector of quantiles.
}
\description{
The quantile function of the tempered stable
subordinator distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, delta, lambda)}.
Either provide the parameters \code{alpha}, \code{delta}, \code{lambda}
individually OR provide \code{theta}. The function searches for a root
between \code{qmin} and \code{qmax} with \code{uniroot}. Boundaries can
either be supplied by the user or a built-in approach using the stable
distribution is used.
}
\examples{
\donttest{
qTSS(0.5,0.5,5,0.01)
qTSS(0.5,0.9,1,10,NULL)
}

}
\seealso{
See also the \code{\link[=pTSS]{pTSS()}} probability function.
}
