% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogisticReg.r
\name{LogisticReg}
\alias{LogisticReg}
\title{Logistic Regression (LR) Imputation}
\usage{
LogisticReg(test.data, Mvalue = "NA", max.score = 1)
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}

\item{max.score}{The max possible response value in test data. By default max.score=1 (i.e.,binary test data).}
}
\value{
A data frame with all missing responses replaced by integrated imputed values.
}
\description{
This function imputes for all missing responses using logistic regression (for binary responses) or
polytomous regression (for polytomous responses). The mice () function with default settings 
from the mice package (Van Buuren & Groothuis-Oudshoorn, 2011 <doi: 10.18637/jss.v045.i03>) is used 
to impute for the missing responses.
}
\examples{
 
        LogisticReg(test.data, Mvalue="NA",max.score=1)
}
\references{
{
Van Buuren, S., & Groothuis-Oudshoorn, K. (2011).
"mice: Multivariate imputation by chained equations in R."
 Journal of statistical software, 45(1), 1-67. DOI: 10.18637/jss.v045.i03.
}
}
