% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_functions.R
\name{incrementPhi}
\alias{incrementPhi}
\title{(Internal) Increment exposure record variable: phi}
\usage{
incrementPhi(
  exposure_record,
  segments_to_apply,
  segment_prob,
  assembly_was_feasible
)
}
\arguments{
\item{exposure_record}{a named list containing exposure records.}

\item{segments_to_apply}{which segments to apply fading to.}

\item{segment_prob}{a vector containing segment-wise classification probabilities of an ability estimate.}

\item{assembly_was_feasible}{see \code{\link{assemblyInFinalThetaSegmentWasFeasibleAtLeastOnceInInterimThetaSegments}}.}
}
\value{
\code{\link{incrementPhi}} returns an updated exposure record.
}
\description{
\code{\link{incrementPhi}} is an internal function for incrementing an exposure record variable.
Specifically, the \code{f_k} is incremented by one if the following conditions are simultaneously met:
\itemize{
  \item{For the final theta segment \emph{k}, shadowtest assembly was feasible at least one times in any item position while interim theta segment was \emph{k}.}
}
}
\keyword{internal}
