% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_functions.R
\name{runMIP}
\alias{runMIP}
\title{(Internal) Run MIP solver}
\usage{
runMIP(
  solver,
  obj,
  mat,
  dir,
  rhs,
  maximize,
  types,
  verbosity,
  time_limit,
  gap_limit_abs,
  gap_limit
)
}
\arguments{
\item{solver}{the solver name.}

\item{obj}{a length-\emph{nd} vector containing objective values.}

\item{mat}{a (\emph{nc}, \emph{nd}) matrix containing left-hand side constraint coefficients.}

\item{dir}{a length-\emph{nc} vector containing equality signs.}

\item{rhs}{a length-\emph{nc} vector containing right-hand side values.}

\item{maximize}{\code{TRUE} to maximize the objective function.
\code{FALSE} to minimize the objective function.}

\item{verbosity}{the verbosity level.}

\item{time_limit}{the time limit.}

\item{gap_limit_abs}{the gap limit in absolute metric.
This determines the criteria the solver uses to declare that optimality is reached.}

\item{gap_limit}{the gap limit in relative metric.
This determines the criteria the solver uses to declare that optimality is reached.}
}
\value{
\code{\link{runMIP}} returns solver output.
This will have different structures depending on what solver is used.
}
\description{
\code{\link{runMIP}} is an internal function for
running a MIP solver.
}
\keyword{internal}
