% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Surv_3Date.R
\name{Surv_3Date}
\alias{Surv_3Date}
\title{Create \link[survival]{Surv} Object using Three \link[base]{Date}s}
\usage{
Surv_3Date(start, stop, censor, units = "years", ...)
}
\arguments{
\item{start, stop, censor}{\link[base]{Date}, \link[base]{POSIXlt} or \link[base]{POSIXct} object}

\item{units}{(optional) \link[base]{character} scalar, time units}

\item{...}{potential parameters, currently not in use}
}
\value{
Function \link{Surv_3Date} returns a \link[survival]{Surv} object.
}
\description{
Create right-censored \link[survival]{Surv} object using start, stop and censoring dates.
}
\examples{
library(survival)
d1 = within(survival::udca, expr = {
  edp_yr = Surv_3Date(entry.dt, death.dt, last.dt, units = 'years')
  edp_mon = Surv_3Date(entry.dt, death.dt, last.dt, units = 'months') 
})
head(d1)

noout = within(survival::udca, expr = {
  edp_bug = Surv_3Date(entry.dt, death.dt, as.Date('1991-01-01'), units = 'months') 
})
subset(survival::udca, subset = entry.dt > as.Date('1991-01-01')) # check error as suggested

}
