% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbinds.R
\name{rbinds}
\alias{rbinds}
\title{Row-Bind a \link[base]{list} of \link[base]{data.frame}}
\usage{
rbinds(x, make.row.names = FALSE, ..., .id = "idx")
}
\arguments{
\item{x}{a \link[base]{list} of named \link[base]{data.frame}}

\item{make.row.names, ...}{additional parameters of \link[base]{rbind.data.frame}}

\item{.id}{\link[base]{character} value to specify the name of ID column,
nomenclature follows \link[data.table]{rbindlist}}
}
\value{
Function \link{rbinds} returns a \link[base]{data.frame}.
}
\description{
..
}
\details{
Yet to look into \code{ggplot2:::rbind_dfs} closely.

Mine is slightly slower than the fastest alternatives, but I have more checks which are useful.
}
\examples{
x = list(A = swiss[1:3, 1:2], B = swiss[5:9, 1:2]) # list of 'data.frame'
rbinds(x)
rbinds(x, make.row.names = TRUE)

}
\references{
\url{https://stackoverflow.com/questions/2851327/combine-a-list-of-data-frames-into-one-data-frame}
}
